Include([[Data/levels/include/level_utils.lua]])

Level =
{
	MapSkinFilename = [[jungle.lua]],
	MapGenScript = LevelUtils.MapGenFromSVG([[tutorial_weapons.svg]]),
	Parameters =
	{
		MarineCount 		= 5,
		StartBPMultiplier 	= 1.7,
		BPGainMultiplier 	= 1.0,
		MaxHiveLevel 		= 4,
		MaxSpawnRate 		= 0.0,
	},
	Mutations =
	{
		CapturesPerMutation = 1,
		MaxMutations = 0,
		Default = [[disabled]],
		Active =
		{
		},
		Queue =
		{
		},
		Disabled =
		{
		},
	},
	MarineUpgrades = 
	{
		--Default = [[locked]],
		Active =
		{
			[[MU_RECYCLE]],
			[[MU_FUSIONRIFLES]],
		},
		Inactive =
		{
		},	
		Locked =
		{
		},			
	}
}

------------------------------------------------------------------------------- Level Init
LevelInit = LevelUtils.MakeGoal(
	nil,
	{[[NT_BEGIN_GAME]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		GameWorld:SetUIVisibility("Objectives", false)
		GameWorld:SetUIVisibility("MutationList", false)
		GameWorld:SetUIVisibility("researchMenu", false)
		
		--GameWorld:SetCapPointCapturable("thirdPoint", false)
		
		UpgradeGoal:Enable()
		
		self:Disable()
	end)
LevelInit:Enable()

------------------------------------------------------------------------------- Upgrade Marines
UpgradeGoal = LevelUtils.MakeGoal(
	function (self)
		self.text_hdl = GameWorld:ShowText("Damn that meddling witch.  We're going to need some bigger guns if we lead the charge.\n\nYou should make some shotguns for your squad.", "Sarge")
		GameWorld:SetUIHighlightArrow("constructionMenu", "Toggle:Training", true)
		GameWorld:SetUIHighlight("trainingMenu", "UpgradeWeapon:WT_FUSIONRIFLE", true)
	end,
	
	{[[NT_ENTITY_UPGRADE]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		if p_other ~= "WT_FUSIONRIFLE" then
			return
		end
		
		self:Disable()
		
		CaptureOneGoal:Enable()
	end,
	
	function (self)
		self.text_hdl:ClearText()
		GameWorld:SetUIHighlightArrow("constructionMenu", "Toggle:Training", false)
		GameWorld:SetUIHighlight("trainingMenu", "UpgradeWeapon:WT_FUSIONRIFLE", false)
	end)

------------------------------------------------------------------------------- Capture one point
CaptureOneGoal = LevelUtils.MakeGoal(
	function (self)
		self.text_hdl = GameWorld:ShowText("Now we've got the firepower to take out that first point\n\nLet's roll devils", "Sarge")
		GameWorld:CreateTrainingArrow("secondPoint")
	end,
	
	{[[NT_POINT_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		
		GameWorld:SetSpawnRate(10.0)
--[[
        if p_entId ~= "secondPoint" then
			return
		end
--]]		
		self:Disable()
		
		--RecycleGoal:Enable()
		--CaptureSkipScript:Enable()
		
		CrateDropScript:Enable()
		CaptureAllObjective:Enable()		
		
	end,
	
	function (self)
		self.text_hdl:ClearText()
		GameWorld:RemoveTrainingArrow("secondPoint")
	end)

------------------------------------------------------------------------------- Skip recycle and build script
CaptureSkipScript = LevelUtils.MakeGoal(
	nil,
	
	{[[NT_POINT_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		
        RecycleGoal:Disable()
        TurretBuildGoal:Disable()
        TurretCompleteGoal:Disable()
		
		CrateDropScript:Enable()
		CaptureAllObjective:Enable()
		
		GameWorld:KillEntity("turretBuildArea")
		
		self:Disable()
	end)
	
------------------------------------------------------------------------------- Recycle a marine's weapon
RecycleGoal = LevelUtils.MakeGoal(
	function (self)
		self.text_hdl = GameWorld:ShowText("We should put a turret here, but damn - not enough metal\n\nYou'll need to recycle one of your shotguns and get all of its metal back", "Sarge")
		GameWorld:SetUIHighlightArrow("commandMenu", "Command:Recycle", true)
		GameWorld:SetUIHighlightArrow("ResourceGroup", "bp_counter", true)
	end,
	
	{[[NT_WEAPON_RECYCLED]], [[NT_ENTITY_UPGRADE]]},
	function (self, p_type, p_entId, p_pos, p_other)	

        if GameWorld:GetBuildPoints() < 7 then
			return
		end
	
		self:Disable()
		
		TurretBuildGoal:Enable()
	end,
	
	function (self)
		self.text_hdl:ClearText()
		GameWorld:SetUIHighlightArrow("commandMenu", "Command:Recycle", false)
		GameWorld:SetUIHighlightArrow("ResourceGroup", "bp_counter", false)
	end)


------------------------------------------------------------------------------- Start Building Turret
TurretBuildGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:ShowText("Got enough metal for a turret? Good\n\nHow about one somewhere here?", "Sarge")
		
		GameWorld:SetUIHighlightArrow("constructionMenu", "Toggle:Armoury", true)
		GameWorld:SetUIHighlight("armouryMenu", "Place:Turret", true)
		
		GameWorld:SetEntityVisible("turretBuildArea", true)
		GameWorld:CreateTrainingArrow("turretBuildArea")
		
		eventArea = GameWorld:GetEntityById("turretBuildArea")
		self.event_pos = eventArea:GetPos()
		self.event_radius = eventArea:GetRadius()
		
	end,
	
	{[[NT_ENTITY_BUILD_ORDERED]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		if p_other ~= "Turret" then
			return
		end
		
		if not vect2f.IsDistLess(p_pos, self.event_pos, self.event_radius) then
			GameWorld:ShowText("No no no, put it INSIDE the circle.\n\nYeah - that giant red ring on the HUD.", "Sarge")
			return
		end
		
		self:Disable()
		
		TurretCompleteGoal:Enable()
	end,
	
	function (self)
		GameWorld:SetUIHighlightArrow("constructionMenu", "Toggle:Armoury", false)
		GameWorld:SetUIHighlight("armouryMenu", "Place:Turret", false)
		
		GameWorld:RemoveTrainingArrow("turretBuildArea")
	end)

------------------------------------------------------------------------------- Complete Turret
TurretCompleteGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:ShowText("This should protect our ass while we blow the buggers up.", "Sarge")

		eventArea = GameWorld:GetEntityById("turretBuildArea")
		self.event_pos = eventArea:GetPos()
		self.event_radius = eventArea:GetRadius()
	end,
	
	{[[NT_ENTITY_BUILD_FINISHED]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		if not vect2f.IsDistLess(p_pos, self.event_pos, self.event_radius) then
			return
		end
		
		self:Disable()
		
		CaptureSkipScript:Disable()
		
		CrateDropScript:Enable()
		CaptureAllObjective:Enable()
	end,
	
	function (self)
		GameWorld:KillEntity("turretBuildArea");
	end)

------------------------------------------------------------------------------- Chopper Delivery
CrateDropScript = LevelUtils.MakeGoal(
	function (self)	
		local crateArea = GameWorld:GetEntityById("crateDropArea");
		if crateArea then
			local chopper = GameWorld:SpawnChopper(vect2f(-0.3, -1.0), crateArea:GetPos())
			chopper:SetMission(ChopperOrder.CO_DELIVERY, crateArea:GetPos(), "Crates")
		end
	end,
	
	{[[NT_CHOPPER_DELIVERY]]},
	function (self, p_type, p_entId, p_pos, p_other)
		
		if p_other ~= "Crates" then
			return
		end
		
		local crate = GameWorld:CreateEntity("WeaponCrate:WT_MEDIC", "", p_pos + vect2f(3.5,0))
		GameWorld:CreateEntity("AmmoCrate", "", p_pos + vect2f(-3.5,3.5))
		GameWorld:CreateEntity("AmmoCrate", "", p_pos + vect2f(-3.5,-3.5))
		
		GameWorld:CreateTrainingArrow(crate)
		
		--GameWorld:ShowText("I love my shotguns - babies kick like a mule though.\n\nLet's grab a couple from those crates down there.", "Sarge")
	
		--WeaponCrateGoal:Enable()
	
		self:Disable()
	end)

------------------------------------------------------------------------------- Dialogue Triggers
DialogueScript = LevelUtils.MakeGoal(
	function (self)
		self.capture_counter = 0
	end,
	
	{[[NT_CAPTURE_RECORD]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		
        self.capture_counter = self.capture_counter + 1
        
        local texthdl = nil
        if self.capture_counter == 3 then
            texthdl = GameWorld:ShowText("#!%* now it is time to sanitize the planet &$%@", "Alien")
        elseif self.capture_counter == 4 then
            texthdl = GameWorld:ShowText("What in the hells was that?  Doc, you hearing this?", "Sarge")
        elseif self.capture_counter == 5 then
            texthdl = GameWorld:ShowText("The signal is coming from the deep caves Drake.  I am streaming it to the science team.", "Scout")
        elseif self.capture_counter == 6 then
            texthdl = GameWorld:ShowText("I don't like this.  Let's clean up and get back to base quick.", "Sarge")
        end
        
        if texthdl then
            ScriptMgr:DoDelayedCall(15000, function () texthdl:ClearText(); end)
        end
      
	end)
DialogueScript:Enable()

------------------------------------------------------------------------------- Tracked objective for capturing everything
CaptureAllObjective = LevelUtils.MakeGoal(
	function (self)
		GameWorld:SetUIVisibility("Objectives", true)
		GameWorld:AddObjective("winObj", "Capture all the enemy points")
		
		local text_hdl = GameWorld:ShowText("Let's move out and sweep the filth out of here\n\nI'm going to call in an airdrop with some more guns", "Sarge")
		ScriptMgr:DoDelayedCall(15000, function () text_hdl:ClearText(); end)	
	end,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ChangeObjectiveStatus("winObj", [[complete]])
	
		self:Disable()
	end)
	
------------------------------------------------------------------------------- Victory Condition - Capture All Points (short-circuit)
CaptureAllGoal = LevelUtils.MakeGoal(
	nil,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ClearText()
		GameWorld:GameOver(true)
		
		self:Disable()
	end) 
CaptureAllGoal:Enable()	
